#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<int> ord(n);
    for (int i = 0; i < n; i++) ord[i] = i;

    sort(ord.begin(), ord.end(), [&](int a, int b) {
        return x[a] < x[b];
    });

    vector<long long> sx(n), sh(n);
    for (int i = 0; i < n; i++) {
        sx[i] = x[ord[i]];
        sh[i] = h[ord[i]];
    }

    vector<long long> ans(n, LLONG_MAX);

    for (int i = 0; i < n; i++) {
        long long xi = sx[i];
        long long hi = sh[i];
        int id = ord[i];

        if (i > 0 && sh[i - 1] >= hi)
            ans[id] = min(ans[id], xi - sx[i - 1]);

        if (i + 1 < n && sh[i + 1] >= hi)
            ans[id] = min(ans[id], sx[i + 1] - xi);

        if (i > 0) {
            long long xl = sx[i - 1], hl = sh[i - 1];
            long long xr = xi;

            long long xp = (xl + hl) - hi;
            if (xp >= xl && xp <= xr)
                ans[id] = min(ans[id], xi - xp);
        }

        if (i + 1 < n) {
            long long xl = xi;
            long long xr = sx[i + 1], hr = sh[i + 1];

            long long xp = (xr - hr) + hi;
            if (xp >= xl && xp <= xr)
                ans[id] = min(ans[id], xp - xi);
        }
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] == LLONG_MAX)
            cout << -1 << '\n';
        else
            cout << ans[i] << '\n';
    }

    return 0;
}